import { Animated, Modal, Pressable, StyleSheet, View } from "react-native";
import React from "react";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";
import { modalHeight } from "./modalHelper";

const CustomModal = (props) => {
    const { isVisible, onCloseModal, modalY, children, price, setPrice } = props;

    const handleOutsideTouch = (onTouch) => {
        onTouch();
        setPrice(price);
    }

    const modalStyle = ModalStyle();

    const outsideTouch = (onTouch) => {
        const view = <View style={modalStyle.outsideTouch} />;
        if (!onTouch) {
            return view;
        }
        return (
            <Pressable 
                onPress={() => handleOutsideTouch(onTouch)} 
                style={modalStyle.outsideTouch}
            >
                {view}
            </Pressable>
        );
    };
    return (
        <>
            <Modal
                visible={isVisible}
                animationType={"fade"}
                onRequestClose={onCloseModal}
                transparent={true}
            >
                <View style={modalStyle.modalCont}>
                    {outsideTouch(onCloseModal)}
                    <Animated.View
                        style={[
                            modalStyle.modalSubCont,
                            modalStyle.modalTransform(modalY)
                        ]}
                    >
                        {children}
                    </Animated.View>
                </View>
            </Modal>
        </>
    );
};

export default CustomModal;

const ModalStyle = () =>
    StyleSheet.create({
        modalCont: {
            flex: 1,
            backgroundColor: "#00000030",
            justifyContent: "flex-end",
        },
        modalSubCont: {
            backgroundColor: "#FFFFFF",
            width: "100%",
            maxHeight: modalHeight,
            minHeight: modalHeight,
            paddingTop: dpr(15),
            borderTopLeftRadius: dpr(10),
            borderTopRightRadius: dpr(10),
        },
        modalTransform: (modalY) => ({
            transform: [{ translateY: modalY }]
        }),
        outsideTouch: {
            flex: 1,
            width: "100%",
        },
    });
